% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumul.poth.R
\name{bestk.poth}
\alias{bestk.poth}
\alias{print.bestk.poth}
\alias{bestk}
\title{Best k treatments method for precision of treatment hierarchy (POTH)
metric}
\usage{
\method{bestk}{poth}(x, sort = TRUE, ...)

\method{print}{bestk.poth}(x, digits = 3, legend = TRUE, ...)

bestk(x, ...)
}
\arguments{
\item{x}{An R object of class \code{poth}.}

\item{sort}{A logical indicating whether results should be sorted
by decreasing ranking metric.}

\item{\dots}{Additional arguments.}

\item{digits}{Minimal number of significant digits, see
\code{\link{print.default}}.}

\item{legend}{A logical indicating whether a legend should be
printed.}
}
\value{
A data frame with additional class \code{bestk.poth} and the
  following variables:
\item{trt}{Name of added treatment.}
\item{rank}{Treatment rank (global).}
\item{score}{Ranking metric (global).}
\item{poth_bestk}{Best k treatments POTH.}
}
\description{
Best k treatments method for precision of treatment hierarchy (POTH)
metric
}
\examples{
\donttest{
library("netmeta")
data(Senn2013)
net1 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013, sm = "MD", random = FALSE)

# Best k treatments method
bk1 <- bestk(poth(net1))
bk1
plot(bk1)
plot(bk1, labels = TRUE)
bk2 <- bestk(poth(net1), sort = FALSE)
bk2
plot(bk2)
plot(bk2, labels = TRUE)
}

}
\keyword{print}
