% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cumul.poth.R
\name{plot.bestk.poth}
\alias{plot.bestk.poth}
\title{Plot best k treatments precision of treatment hierarchy (POTH) values}
\usage{
\method{plot}{bestk.poth}(x, labels = FALSE, nchar.trts = 4, digits = 3, ...)
}
\arguments{
\item{x}{R object of class \code{bestk.poth}.}

\item{labels}{A logical indicating whether treatment names should be
shown in the plot.}

\item{nchar.trts}{Number of characters to keep for each treatment name if labels = TRUE.}

\item{digits}{Minimal number of significant digits for best k treatments POTH, see
\code{\link{print.default}}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
A ggplot2 object.
}
\description{
Plot best k treatments precision of treatment hierarchy (POTH) values
}
\details{
Plot results of best k treatments method for precision of treatment hierarchy (POTH) metric
(Wigle et al., 2024).
}
\examples{
\donttest{
library("netmeta")
data(Senn2013)
net1 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
  data = Senn2013, sm = "MD", random = FALSE)

# Best k treatments method
bk1 <- bestk(poth(net1))
bk1
plot(bk1)
plot(bk1, labels = TRUE)
bk2 <- bestk(poth(net1), sort = FALSE)
bk2
plot(bk2)
plot(bk2, labels = TRUE)
}
}
\references{
Wigle A, Béliveau A, Salanti G, Rücker G, Schwarzer G, Mavridis D,
Nikolakopoulou A (2024):
Precision of treatment hierarchy: A metric for quantifying uncertainty in
treatment hierarchies in network meta-analysis.
Preprint on arXiv, \doi{10.48550/arXiv.2501.11596}
}
\author{
Augustine Wigle \email{amhwigle@uwaterloo.ca},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
