% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_potools_sys_reqs}
\alias{check_potools_sys_reqs}
\title{Check if the proper system utilities for running package translation are
installed}
\usage{
check_potools_sys_reqs(which = SYSTEM_REQUIREMENTS)
}
\arguments{
\item{which}{Which requirements to test for. Defaults to all of
the command-line utilities on which potools relies, namely,
\itemize{
\item \code{msgmerge}
\item \code{msgfmt}
\item \code{msginit}
\item \code{msgconv}
}}
}
\value{
\code{TRUE} if the system is ready for translation, otherwise a
message suggesting how to proceed.
}
\description{
potools uses the same gettext command line tools that R itself does to run
translation. These are required for translation to work properly; this
function is mainly for testing use & checks whether the current environment
is equipped for translation.
}
\details{
Specifically, potools relies on these command-line utilities:
}
\seealso{
\code{\link[tools:update_pkg_po]{tools::update_pkg_po()}}
}
\author{
Michael Chirico
}
