% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/po_create.R
\name{po_create}
\alias{po_create}
\title{Create a new \code{.po} file}
\usage{
po_create(languages, dir = ".", verbose = !is_testing())
}
\arguments{
\item{languages}{Language identifiers. These are typically two letters (e.g.
"en" = English, "fr" = French, "es" = Spanish, "zh" = Chinese), but
can include an additional suffix for languages that have regional
variations (e.g. "fr_CN" = French Canadian, "zh_CN" = simplified
characters as used in mainland China, "zh_TW" = traditional characters
as used in Taiwan.)}

\item{dir}{Character, default the present directory; a directory in which an
R package is stored.}

\item{verbose}{Logical, default \code{TRUE} (except during testing). Should
extra information about progress, etc. be reported?}
}
\description{
\code{po_create()} creates a new \verb{po/\{languages\}.po} containing the messages to be
translated.

Generally, we expect you to use \code{po_create()} to create new \code{.po} files
but if you call it with an existing translation, it will update it with any
changes from the \code{.pot}. See \code{\link[=po_update]{po_update()}} for details.
}
