% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.powRICLPM}
\alias{summary.powRICLPM}
\title{Summarize Results from \code{powRICLPM} Object}
\usage{
\method{summary}{powRICLPM}(
  object,
  ...,
  parameter = NULL,
  sample_size = NULL,
  time_points = NULL,
  ICC = NULL,
  reliability = NULL
)
}
\arguments{
\item{object}{A \code{powRICLPM} object.}

\item{...}{(don't use)}

\item{parameter}{Character string of length 1 denoting the parameter to visualize the results for.}

\item{sample_size}{(optional) An \code{integer}, denoting the sample size of the experimental condition of interest.}

\item{time_points}{(optional) An \code{integer}, denoting the number of time points of the experimental condition of interest.}

\item{ICC}{(optional) A \code{double}, denoting the proportion of variance at the between-unit level of the experimental condition of interest.}

\item{reliability}{(optional) An \code{integer}, denoting the reliability of the indicators of the experimental condition of interest.}
}
\value{
No return value, called for side effects.
}
\description{
S3 method for class \code{powRICLPM}. \code{summary.powRICLPM} summarizes the setup and results of the \code{powRICLPM} analysis. Depending on the arguments that are set, \code{summary.powRICLPM} provides a different summary (see "Details").
}
\details{
\code{summary.powRICLPM} provides a different summary of the \code{powRICLPM} object, depending on the additional arguments that are set:
\itemize{
\item When \code{sample_size = ...}, \code{time_points = ...}, \code{ICC = ...}, and \code{reliability} are set: Estimation information and results for all parameters across experimental conditions.
\item When \code{parameter = "..."} is set: Estimation information and results for a specific parameter across all experimental conditions.
\item No additional arguments: Characteristics of the different experimental conditions are summarized, as well as session info (information that applies to all conditions, such the number of replications, etc.).
}
\subsection{Interpretation Output}{Depending on the arguments that you set, \code{summary()} prints a table with different analysis outcomes in the columns and where each row refers to a different experimental condition. The following information is available:
\itemize{
\item \code{Sample size}, \code{Time points}, \code{ICC}, \code{Reliability}: The experimental condition that the row refers to.
\item \code{Population}: The true value of the parameter.
\item \code{Avg}: The average (across replications) parameter estimate.
\item \code{Bias}: The difference between the population value and the average parameter estimate.
\item \code{Min}: The lowest (across replications) parameter estimate.
\item \code{SD}: The standard deviation of the parameter estimate over replications.
\item \code{SEAvg}: The average (across replications) standard error of the parameter estimate.
\item \code{MSE}: The parameter mean square error, combining a parameter's bias and efficiency.
\item \code{Accuracy}: The average (across replications) width of the confidence interval.
\item \code{Cover}: The coverage rate, representing the proportion of times (across replications) the true parameter estimate fell in the confidence interval.
\item \code{Power}: The proportion of times (across replications) the confidence interval did not contain zero.
\item \code{Error}: The number of replications that failed to run (i.e., \code{lavaan()} produced an error).
\item \code{Not converged}: The number of replications that did not converge to a solution.
\item \code{Inadmissible}: The number of replications that converged to an inadmissible solution (e.g., a variance estimated to be lower than zero).
}
}
}
\examples{
\dontshow{load(system.file("extdata", "out_preliminary.RData", package = "powRICLPM"))}
# Get setup of powRICLPM analysis and convergence issues
summary(out_preliminary)

# Performance measures for "wB2~wA1" parameter across experimental conditions
summary(out_preliminary, parameter = "wB2~wA1")

# Performance measures for all parameters, for specific experimental condition
summary(out_preliminary, sample_size = 700, time_points = 4, ICC = .3, reliability = 1)

}
