% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmAltBirthDeath.R
\name{genAltBirthDeathTree}
\alias{genAltBirthDeathTree}
\title{Generation of rooted binary trees under the alternative birth-death model}
\usage{
genAltBirthDeathTree(n, BIRTHRATE = 1, DEATHRATE = 0, TRIES = 5)
}
\arguments{
\item{n}{Integer value that specifies the desired number of leaves, i.e.,
vertices with in-degree 1 and out-degree 0.\cr
Due to the restrictions of the \code{phylo} or \code{multiphylo} format,
the number of leaves must be at least 2 since there must be at
least one edge.}

\item{BIRTHRATE}{Positive numeric value (default = 1) which specifies the
rate at which the speciation events occur.}

\item{DEATHRATE}{Positive numeric value (default = 0) which specifies the
rate at which the extinction events occur.}

\item{TRIES}{Integer value (default = 5) that specifies
the number of attempts to generate a tree with \code{n} leaves.}
}
\value{
\code{genAltBirthDeathTree} A single tree of class \code{phylo} is
returned.
}
\description{
\code{genAltBirthDeathTree} - Generates a rooted binary tree in \code{phylo}
format with the given number of \code{n} leaves under the alternative
birth-death model.
In the alternative birth-death process all species have the same speciation
\code{BIRTHRATE} and extinction rates \code{DEATHRATE}. Extinct species
remain as fossils inside the tree with zero speciation and extinction
rates.
}
\examples{
genAltBirthDeathTree(n = 7, DEATHRATE = 1)
}
\references{
\itemize{
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic models.
arXiv:2406.05185, 2024.
\item S. J. Kersting, K. Wicke, and M. Fischer. Tree balance in phylogenetic
models: Supplementary material. https://tinyurl.com/278cwdh8, 2024.
}
}
