% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tssInfo.R
\docType{data}
\name{tssInfo}
\alias{tssInfo}
\title{Tree shape statistics}
\format{
An object of class \code{list} of length 29.
}
\usage{
tssInfo
}
\description{
\code{tssInfo} - List that provides information on available tree shape
statistics (TSS) from the package 'treebalance'.
Most of them are either balance or imbalance indices. The indices are grouped
by their families and otherwise sorted alphabetically by their full names.\cr
The following information is provided: \cr
\itemize{
\item short: Abbreviation of the name (plain characters). \cr
\item simple: Simplified full name (plain characters). \cr
\item name: Full name (partly expressions as some names use special symbols).\cr
\item func: Function of the TSS. \cr
\item type: Either "tss", "bali", or "imbali" expressing what type of tree shape
statistic it is. \cr
\item only_binary: TRUE if TSS is suitable only for binary trees, FALSE if also
applicable to arbitrary rooted trees. \cr
\item safe_n : Integer vector with two entries specifying the range of leaf
numbers \code{n} for which the TSS can be (safely) used, without
warnings for too few leaves or values reaching Inf for too many
leaves.\cr
c(4,800), for example means that this TSS should only be applied
on trees with 4 to 800 leaves. 'Inf' as the second entry means
that there is no specific upper limit, but that the size of the
tree itself and the computation time are the limiting factors.\cr
\item col: Color for the TSS (related TSS have similar colors).
}
}
\examples{
tssInfo$ALD$name
tssInfo$ALD$func(genYuleTree(6))
}
\references{
\itemize{
\item M. Fischer, L.Herbst, S. J. Kersting, L. Kühn, and K. Wicke,
Tree Balance Indices - A Comprehensive Survey. Springer, 2023.
ISBN: 978-3-031-39799-8
}
}
\keyword{datasets}
