% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransformationYeoJohnson.R
\docType{class}
\name{transformationYeoJohnson-class}
\alias{transformationYeoJohnson-class}
\alias{transformationYeoJohnsonInvariant-class}
\title{Yeo-Johnson transformation object}
\description{
This class is used for Yeo-Johnson transformations.
}
\section{Slots}{

\describe{
\item{\code{method}}{Main transformation method, i.e. \code{"yeo_johnson"}.}

\item{\code{robust}}{Indicates whether a robust version of the Yeo-Johnson
transformation is used to set transformation parameters. The value depends
on the \code{robust} argument of the \code{find_transformation_parameters} function.}

\item{\code{lambda}}{Numeric lambda parameter for the Yeo-Johnson transformation.}

\item{\code{shift}}{Numeric shift parameter for the Yeo-Johnson transformation. If
\code{invariant=TRUE} in the \code{find_transformation_parameters} function,
\code{lambda}, \code{shift} and \code{scale} parameters are optimised simultaneously.
Otherwise, the \code{shift} parameter has a value of \code{0.0}.}

\item{\code{scale}}{Numeric scale parameter for the Yeo-Johnson transformation. If
\code{invariant=TRUE} in the \code{find_transformation_parameters} function,
\code{lambda}, \code{shift} and \code{scale} parameters are optimised simultaneously.
Otherwise, the \code{scale} parameter has a value of \code{1.0}.}

\item{\code{complete}}{Indicates whether transformation parameters were set.}
}}

\seealso{
\link{find_transformation_parameters}
}
