% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_moderation.R
\name{test_moderation}
\alias{test_moderation}
\title{Test All Moderation Effects}
\usage{
test_moderation(
  fit = fit,
  standardized = FALSE,
  check_post_check = TRUE,
  ...,
  fit_name = "fit",
  get_map_names = FALSE,
  get_test_name = FALSE
)
}
\arguments{
\item{fit}{The fit object, to be
passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}},
or \code{\link[lmhelprs:lm_list_to_partable]{lmhelprs::lm_list_to_partable()}}.}

\item{standardized}{Logical. If \code{TRUE},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}} will
be used. Can be used only with models
fitted by \code{lavaan}.}

\item{check_post_check}{Logical. If
\code{TRUE}, the default, and the model
is fitted by \code{lavaan}, the test
will be conducted only if the model
passes the \code{post.check} conducted
by \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} (with
\code{what = "post.check"}).}

\item{...}{Additional arguments to
be passed to \code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}},
\code{\link[lavaan:standardizedSolution]{lavaan::standardizedSolution()}},
or \code{\link[lmhelprs:lm_list_to_partable]{lmhelprs::lm_list_to_partable()}}.}

\item{fit_name}{The name of the fit
results for which the parameter names
will be displayed. Default is \code{"fit"}.}

\item{get_map_names}{Logical. Used
by \code{\link[=power4test]{power4test()}} to determine how
to extract stored information and
assign them to this function. Users
should not use this argument.}

\item{get_test_name}{Logical. Used
by \code{\link[=power4test]{power4test()}} to get the default
name of this test. Users should not
use this argument.}
}
\value{
In its normal usage, it returns
the output returned by
\code{\link[lavaan:parameterEstimates]{lavaan::parameterEstimates()}}
or \code{\link[lmhelprs:lm_list_to_partable]{lmhelprs::lm_list_to_partable()}},
with the following modifications:
\itemize{
\item \code{est}: The parameter estimates,
even if standardized estimates
are requested (not \code{est.std}).
\item \code{cilo} and \code{cihi}: The
lower and upper limits of the
confidence interval (95\% by
default), respectively (not
\code{ci.lower} and \code{ci.upper}).
\item \code{sig}: Whether a test by confidence
interval is significant (\code{1}) or
not significant (\code{0}).
\item \code{test_label}: A column of labels
generated by
\code{\link[lavaan:lav_partable]{lavaan::lav_partable_labels()}},
which are usually the labels used by
\code{coef()} to label the parameters.
}
}
\description{
Test all moderation
effects by testing all product
terms for a \code{power4test} object.
}
\details{
This function is to be used in
\code{\link[=power4test]{power4test()}} for testing all
product terms, by
setting it to the \code{test_fun}
argument.

It is just a wrapper to
\code{\link[=test_parameters]{test_parameters()}}. It will
first identifies all product
terms (terms with \code{:} in the names),
and then call \code{\link[=test_parameters]{test_parameters()}},
with \code{pars} set to select the
regression coefficients of these
terms.
}
\examples{

# Specify the model

mod <-
"
m ~ x + w1 + x:w1
y ~ m + x
"

# Specify the population values

mod_es <-
"
m ~ x: n
y ~ x: m
m ~ w1: n
m ~ x:w1: l
"

# Simulate the data

sim_only <- power4test(nrep = 4,
                       model = mod,
                       pop_es = mod_es,
                       n = 100,
                       do_the_test = FALSE,
                       iseed = 1234)

# Do the test in each replication

test_out <- power4test(object = sim_only,
                       test_fun = test_moderation)

print(test_out,
      test_long = TRUE)

}
\seealso{
\code{\link[=power4test]{power4test()}},
\code{\link[=test_parameters]{test_parameters()}}
}
