% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerLATE.R
\name{powerLATE}
\alias{powerLATE}
\title{Generalized Power Analysis for LATE}
\usage{
powerLATE(pZ = 0.5, pi, N, kappa,
	sig.level = 0.05, power,
	effect.size = TRUE, tau = NULL, omega = NULL,
	assume.ord.means = FALSE, verbose = TRUE)
}
\arguments{
\item{pZ}{probability of being assigned to treatment. Default is 0.5, i.e. equal assignment probability.}

\item{pi}{compliance rate. Equivalently, average causal effect of treatment assignment on treatment uptake.}

\item{N}{total sample size.}

\item{kappa}{LATE effect size (i.e. effect size for compliers).}

\item{sig.level}{significance level (Type I error probability). Default is 0.05.}

\item{power}{power of test (1 minus Type II error probability).}

\item{effect.size}{whether effect size (kappa) rather than absolute effect (tau) is used in power calculations. Default is \code{TRUE}.}

\item{tau}{LATE absolute effect (i.e. absolute effect for compliers). Must only be supplied if \code{effect.size = FALSE}.}

\item{omega}{within-group standard deviation of the outcome. Must be supplied if \code{effect.size = FALSE}. See Details.}

\item{assume.ord.means}{whether ordered means assumption is made. Default is \code{FALSE}. See Details.}

\item{verbose}{print input and output parameter values. Default is \code{TRUE}.}
}
\value{
A list that includes the values of the input parameters supplied by the user (\code{input.parameter}) and the corresponding output value(s) 
of the target parameter (\code{output.parameter}).

Note also that the results along with additional information will be displayed in the console if \code{verbose = TRUE}.
}
\description{
Function to perform generalized power analysis for the LATE (i.e. under noncompliance with treatment assignment). 
Function allows for user to work with either standardized effect sizes or absolute effects. 
The results provided presume a test of the null hypothesis that the LATE equals 0 with a two-sided alternative.
}
\details{
If \code{effect.size = TRUE} (the default setting), exactly two of the parameters \{\code{kappa, N, power}\} must be supplied, 
from which the third (target) parameter will be calculated. If \code{effect.size = FALSE}, \code{omega} must be supplied, and exactly two of 
the parameters \{\code{tau, N, power}\} must be supplied. \code{pi} must always be supplied, and the user can change \code{pZ} and \code{sig.level} 
from their default values.

The user may also supply one of \{\code{kappa, N, power, pi, tau}\} as a vector of values to perform multiple power calculations at a time, 
in which case the target parameter will be calculated for that entire vector.

If \code{effect.size = FALSE}, \code{omega} represents the reference within-assignment-group standard deviation of the outcome. The user may wish to 
use an estimate of the standard deviation of the outcome prior to the intervention (i.e. in the absence of the treatment). 
See "Discussion on Effect Sizes" section in Bansak (2020) for more information and guidance.

The \code{assume.ord.means} argument allows the user to choose whether or not to make the ordered means assumption, presented and described in Bansak (2020). 
Users should only make this assumption (i.e. set \code{assume.ord.means = TRUE}) if they are reasonably confident that it will be met in their context of interest. 
See "Narrowing the Bounds" section in Bansak (2020) for more information and guidance.
}
\examples{
#EXAMPLE 1
#Recovering power, without ordered-means assumption
#powerLATE(pi = 0.5, N = 3000, kappa = 0.25)
results <- powerLATE(pi = 0.5, N = 3000, kappa = 0.25)
results$input.parameter
results$output.parameter

#EXAMPLE 2
#Recovering power for various compliance rates,
#without ordered-means assumption, and with unequal treatment-assignment probability
powerLATE(pZ = 0.25, pi = c(0.3,0.4,0.5,0.6,0.7), N = 3000, kappa = 0.25)

#EXAMPLE 3
#Again recovering power for various compliance rates,
#this time with the ordered-means assumption
powerLATE(pi = c(0.3,0.4,0.5,0.6,0.7), N = 3000, kappa = 0.25,
          assume.ord.means = TRUE)

#EXAMPLE 4
#Recovering power, without ordered-means assumption, 
#this time using absolute effect rather than effect size
powerLATE(pi = 0.5, N = 3000, 
          effect.size = FALSE, tau = 300, omega = 1500)

#EXAMPLE 5
#Recovering required sample size for various compliance rates,
#with ordered-means assumption
powerLATE(pi = c(0.5,0.6,0.7,0.8), kappa = 0.25,
          power = 0.8, assume.ord.means = TRUE)

#EXAMPLE 6
#Recovering required sample size for various compliance rates,
#with ordered-means assumption, and specifying absolute effect
powerLATE(pi = c(0.5,0.6,0.7,0.8),
          power = 0.8, assume.ord.means = TRUE,
          effect.size = FALSE, tau = 25, omega = 125)

#EXAMPLE 7
#Recovering minimum detectable effect size for various sample sizes,
#without ordered-means assumption
powerLATE(pi = 0.6, N = c(1000,1500,2000,2500,3000),
          power = 0.8)

#EXAMPLE 8
#Recovering minimum detectable effect (absolute) for various sample sizes,
#with ordered-means assumption, and with unequal treatment-assignment probability
powerLATE(pZ = 0.4, pi = 0.6, N = c(1000,1500,2000,2500,3000),
          power = 0.8, assume.ord.means = TRUE, 
          effect.size = FALSE, omega = 50)
}
\references{
Bansak, K. (2020). A Generalized Approach to Power Analysis for Local Average Treatment Effects. Statistical Science, 35(2), 254-271.
}
\author{
Kirk Bansak and Eddie Yang
}
