% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.Validation}
\alias{plot.Validation}
\title{Plot the results of a sample size analysis validation}
\usage{
\method{plot}{Validation}(x, save = FALSE, path = NULL, width = 14, height = 10, bins = 20, ...)
}
\arguments{
\item{x}{An object instance of class \code{Validation}.}

\item{save}{A logical value indicating whether the plot should be saved to a
file on disk.}

\item{path}{A character string representing the path (i.e., including the
filename and extension) where the plot should be saved on disk. If \code{NULL},
the plot will be saved in the current working directory with a filename
generated based on the current system time and a \code{.pdf} extension. See
\code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for supported file types.}

\item{width}{A single numerical value representing the desired plot width.
The default unit is inches (i.e., set by \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}), unless
overridden by providing the \code{units} argument via \code{...}.}

\item{height}{A single numerical value representing the desired plot height.
The default unit is inches (i.e., set by \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}), unless
overridden by providing the \code{units} argument via \code{...}.}

\item{bins}{A single positive integer passed to \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}}
representing the number of bins to use for the histogram plot. The default
value is \code{20}.}

\item{...}{Optional arguments to be passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}
}
\value{
An \link[ggplot2:ggplot]{ggplot2::ggplot} object containing the plot for the validation procedure.
The plot object returned can be further modified and also contains the
\link[patchwork:patchwork-package]{patchwork::patchwork} class applied.

\if{html}{
Example of a validation plot:
\out{<span style="display: block; text-align: center; margin-top: 1rem;">}
\figure{example-validation.png}{options: style="width: 640px; max-width: 90\%;" alt="Example Validation"}
\out{</span>}
}
}
\description{
This function plots the results for of a sample size analysis validation.
}
\seealso{
\code{\link[=summary.Validation]{summary.Validation()}}, \code{\link[=validate]{validate()}}
}
