% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmhp_event_state.R
\name{mmhp_event_state}
\alias{mmhp_event_state}
\title{Estimate the latent state for events of an MMHP}
\usage{
mmhp_event_state(
  params = list(lambda0, lambda1, alpha, beta, Q),
  events,
  start = 0
)
}
\arguments{
\item{params}{the parameters of the chosen MMHP}

\item{events}{the event times}

\item{start}{the start of observation}
}
\value{
probability of being in state 1 (active state) at each event,
along with most likely state
}
\description{
Given a MMHP object and events from that MMHP, infer the
most likely state of the Markov Process and each event time, along
with the probability of being in the active state.
}
\examples{
Q <- matrix(c(-0.4, 0.4, 0.2, -0.2), ncol = 2, byrow = TRUE)
mmhp_obj <- pp_mmhp(Q,
  delta = c(1 / 3, 2 / 3), lambda0 = 0.9,
  lambda1 = 1.1,
  alpha = 0.8, beta = 1.2
)
## evaluate at some fake event times
ppdiag:::mmhp_event_state(params = mmhp_obj, events = c(1, 2, 3, 5))
}
\keyword{internal}
