% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SM_output.linear_fe.R
\name{SM_output.linear_fe}
\alias{SM_output.linear_fe}
\title{Calculate direct/indirect standardized differences from a fitted \code{linear_fe} object}
\usage{
\method{SM_output}{linear_fe}(fit, parm, stdz = "indirect", null = "median", ...)
}
\arguments{
\item{fit}{a model fitted from \code{linear_fe}.}

\item{parm}{specifies a subset of providers for which confidence intervals are to be given.
By default, all providers are included. The class of \code{parm} should match the class of the provider IDs.}

\item{stdz}{a character string or a vector specifying the standardization method(s).
The possible values are:
\itemize{
\item{\code{"indirect"}} (default) indirect standardization method.
\item{\code{"direct"}} direct standardization method.
\item{\code{c("indirect", "direct")}} outputs both direct and indirect standardized measures.
}}

\item{null}{a character string or a number defining the population norm.
The default value is \code{"median"}. The possible values are:
\itemize{
\item{\code{"median"}} the median of the provider effect estimates (\eqn{\hat{\gamma}_i}).
\item{\code{"mean"}} the weighted average of the provider effect estimates (\eqn{\hat{\gamma}_i}), where the weights correspond to the sample size of each provider.
\item{numeric} a user-defined numeric value representing the population norm.
}}

\item{\dots}{additional arguments that can be passed to the function.}
}
\value{
A list containing the standardized differences based on the method(s) specified in \code{stdz},
as well as the observed and expected outcomes used to calculate the standardized measures:
\item{indirect.difference}{indirect standardized differences, if \code{stdz} includes \code{"indirect"}.}
\item{direct.difference}{direct standardized differences, if \code{stdz} includes \code{"direct"}.}
\item{OE}{a list of data frames containing the observed and expected outcomes used for calculating standardized measures.}
}
\description{
Provide direct/indirect standardized differences for a fixed effect linear model.
}
\details{
This function computes standardized differences for a fixed effect linear model
using either direct or indirect methods, or both when specified.
For each method, the population norm is determined by the \code{null} argument.
The population norm can be the median of the estimates, their weighted mean
(with weights corresponding to provider sizes), or a user-defined numeric value.
}
\examples{
data(ExampleDataLinear)
outcome <- ExampleDataLinear$Y
covar <- ExampleDataLinear$Z
ProvID <- ExampleDataLinear$ProvID
fit_linear <- linear_fe(Y = outcome, Z = covar, ProvID = ProvID)
SM_output(fit_linear)
SM_output(fit_linear, stdz = "direct", null = "mean")

}
