% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize_pps}
\alias{visualize_pps}
\title{Visualize the Predictive Power scores of the entire dataframe, or given a target}
\usage{
visualize_pps(
  df,
  y = NULL,
  color_value_high = "#08306B",
  color_value_low = "#FFFFFF",
  color_text = "#FFFFFF",
  include_target = TRUE,
  ...
)
}
\arguments{
\item{df}{data.frame containing columns for x and y}

\item{y}{string, column name of target variable,
can be left \code{NULL} to visualize all X-Y PPS}

\item{color_value_high}{string, hex value or color name used for upper limit of PPS gradient (high PPS)}

\item{color_value_low}{string, hex value or color name used for lower limit of PPS gradient (low PPS)}

\item{color_text}{string, hex value or color name used for text, best to pick high contrast with \code{color_value_high}}

\item{include_target}{boolean, whether to include the target variable in the barplot}

\item{...}{any arguments passed to \code{\link{score}}}
}
\value{
a ggplot object, a vertical barplot or heatmap visualization
}
\description{
If \code{y} is specified, \code{visualize_pps} returns a barplot of the PPS of
every predictor on the specified target variable.
If \code{y} is not specified, \code{visualize_pps} returns a heatmap visualization
of the PPS for all X-Y combinations in a dataframe.
}
\examples{
visualize_pps(iris, y = 'Species')

\donttest{visualize_pps(iris)}

\donttest{visualize_pps(mtcars, do_parallel = TRUE, n_cores = 2)}
}
