% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.predictNMBsim}
\alias{summary.predictNMBsim}
\title{Create table summaries of \code{predictNMBsim} objects.}
\usage{
\method{summary}{predictNMBsim}(
  object,
  what = c("nmb", "inb", "cutpoints"),
  inb_ref_col = NULL,
  agg_functions = list(median = function(x) {
     round(stats::median(x), digits = 2)

    }, `95\% CI` = function(x) {
     paste0(round(stats::quantile(x, probs = c(0.025,
    0.975)), digits = 1), collapse = " to ")
 }),
  rename_vector,
  ...
)
}
\arguments{
\item{object}{A \code{predictNMBsim} object.}

\item{what}{What to summarise: one of "nmb", "inb" or "cutpoints".
Defaults to "nmb".}

\item{inb_ref_col}{Which cutpoint method to use as the reference strategy
when calculating the incremental net monetary benefit. See \code{do_nmb_sim}
for more information.}

\item{agg_functions}{A named list of functions to use to aggregate the
selected values. Defaults to the median and 95\% interval.}

\item{rename_vector}{A named vector for renaming the methods in the summary.
The values of the vector are the default names and the names given are the
desired names in the output.}

\item{...}{Additional, ignored arguments.}
}
\value{
Returns a \code{tibble}.
}
\description{
Create table summaries of \code{predictNMBsim} objects.
}
\details{
Table summaries will be based on the \code{what} argument.
Using "nmb" returns the simulated values for NMB, with no reference group;
"inb" returns the difference between simulated values for NMB and a set
strategy defined by \code{inb_ref_col}; "cutpoints" returns the cutpoints
selected (0, 1).
}
\examples{

# perform simulation with do_nmb_sim()
\donttest{
get_nmb <- function() c("TP" = -3, "TN" = 0, "FP" = -1, "FN" = -4)
sim_obj <- do_nmb_sim(
  sample_size = 200, n_sims = 50, n_valid = 10000, sim_auc = 0.7,
  event_rate = 0.1, fx_nmb_training = get_nmb, fx_nmb_evaluation = get_nmb,
  cutpoint_methods = c("all", "none", "youden", "value_optimising")
)
summary(
  sim_obj,
  rename_vector = c(
    "Value_Optimising" = "value_optimising",
    "Treat_None" = "none",
    "Treat_All" = "all",
    "Youden_Index" = "youden"
  )
)
}
}
