% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\docType{class}
\name{BayesPrefClass}
\alias{BayesPrefClass}
\title{An object containing all data necessary for preference elicitation.}
\description{
An object containing all data necessary for preference elicitation.
}
\section{Fields}{

\describe{
\item{\code{data}}{A matrix or dataframe of data.}

\item{\code{priors}}{A list of functions that give the prior on each variable.}

\item{\code{sigma}}{A scalar value to use for the confusion factor (default 0.1).}

\item{\code{Sigma}}{(Internal use only) A matrix of sigma * diag(ncol(data)).}

\item{\code{strict}}{A list of lists of preferences. For each element x, x[[1]] > x[[2]].}

\item{\code{indif}}{A list of lists of indifference preferences. For each element x, x[[1]] = x[[2]].}

\item{\code{weights}}{A vector of weights determined by the inference algorithm.}
}}

\section{Methods}{

\describe{
\item{\code{addPref(x)}}{Adds a preference created using \%>\%, \%<\%, or \%=\%.}

\item{\code{infer(estimate = "recommended")}}{Calls the ``infer'' function to guess weights}

\item{\code{rank()}}{Calculates the utility of each row in our dataset}

\item{\code{suggest(maxComparisons = 10)}}{Calls the ``suggest'' function to guess weights}
}}

