% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presmoothTP.R
\name{presmoothTP}
\alias{presmoothTP}
\title{This function implements presmoothed estimates based on the landmark 
Aalen-Johansen method for non-parametric estimation of transition 
probabilities in non-Markov
multi-state models.}
\usage{
presmoothTP(data, s, from, to, method = "LM", trans)
}
\arguments{
\item{data}{A data frame in the long format containing the subject id; 
from corresponding to the starting state; the receiving state, to; the 
transition number, trans; the starting time of the transition given by 
Tstart; the stopping time of the transition, Tstop, and status for the status
variable, with 1 indicating an event (transition), 0 a censoring.}

\item{s}{The first time for obtaining estimates for the transition.}

\item{from}{The starting state of the transition probabilities.}

\item{to}{The last receiving state considered for the estimation of the 
transition probabilities.}

\item{method}{The method used to compute the transition probabilities.
Possible options are \code{"PLM"}, \code{"cauchit"} and \code{"probit"}.}

\item{trans}{The transition matrix for multi-state model.}
}
\value{
Nonparametric presmoothed estimates of transition probabilities 
based on logistic’, ’probit’, and ’cauchit’ distributions (PLM,cauchit and 
probit).
}
\description{
This function is used to obtain nonparametric presmoothed 
estimates of the transition probabilities for any type of multistate model, 
including models that allow for reversible transitions, and potencially
non-Markovian seetings. The methods used to compute the transition
probabilities are ”PLM” (given by a ”logistic” model), ”cauchit”, ”probit”.
The proposed presmoothed estimator is designed to handle complex multi-state 
models with more than three states, as well as reversible transitions, 
accommodating potentially non-Markovian behaviors.
}
\examples{
data("ebmt4")
db_wide <- ebmt4
positions<-list(c(2, 3, 5, 6), c(4, 5, 6), c(4, 5, 6), c(5, 6), c(6), c())
states.names = c("Tx", "Rec", "AE", "Rec+AE", "Rel", "Death")
trans<-transTP(positions, states.names)
times.names = c(NA, "rec", "ae","recae", "rel", "srv")
status.names=c(NA, "rec.s", "ae.s", "recae.s", "rel.s", "srv.s")
data.long<-prepTP(data=db_wide, trans, times.names, status.names)

res1<-presmoothTP(data.long, s = 100, from = 1, to = 1, 
method = 'PLM', trans=trans)
res2<-presmoothTP(data.long, s = 100, from = 1, to = 1, method = 'cauchit', 
trans=trans)
res3<-presmoothTP(data.long, s = 100, from = 1, to = 1, method = 'probit', 
trans=trans)

plot(res1, type='s', xlim=c(100,3000), ylim=c(0.6,1), ylab=c('p11(100,t)'))
lines(res2, type='s', col=2)
lines(res3, type='s', col=4)
legend("topright", legend = c("PLM","Cauchit", "Probit"), lwd = 0.3, 
col = c(1,2,4), cex=0.7, lty=c(1, 1))
res4<-presmoothTP(data.long, s = 1000, from = 2, to = 6, method = 'PLM', 
trans=trans)
res5<-presmoothTP(data.long, s = 1000, from = 2, to = 6, method = 'cauchit', 
trans=trans)
res6<-presmoothTP(data.long, s = 1000, from = 2, to = 6, method = 'probit', 
trans=trans)
plot(res4, type='s', xlim=c(1000,3000), ylim=c(0,0.12),ylab=c('p26(1000,t)'))
lines(res5, type='s', col=2)
lines(res6, type='s', col=4)
legend("topright", legend = c("PLM","Cauchit", "Probit"), lwd = 0.3, 
col = c(1,2,4), cex=0.7, lty=c(1, 1))

}
\author{
Gustavo Soutinho and Luis Meira-Machado.
}
