% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{cpei}
\alias{cpei}
\title{CPEI}
\usage{
cpei(pressure_data, foot_side, plot_result = TRUE)
}
\arguments{
\item{pressure_data}{List. First item is a 3D array covering each timepoint
of the measurement. Not currently available for pedar.}

\item{foot_side}{String. "right" or "left". Required for automatic detection
of points}

\item{plot_result}{Logical. Plots pressure image with COP and CPEI overlaid}
}
\value{
Numeric. CPEI value
}
\description{
Determine Center of Pressure Excursion Index (CPEI) for
footprint pressure data
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
cpei(pressure_data, foot_side = "auto", plot_result = FALSE)
\dontshow{\}) # examplesIf}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
