% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcs_ptp.R
\name{calculate_dcs_1993_risk_factor_index}
\alias{calculate_dcs_1993_risk_factor_index}
\title{Calculate The Risk Factor Index For Duke Clinical Score 1993}
\usage{
calculate_dcs_1993_risk_factor_index(
  have_hypertension,
  have_dyslipidemia,
  have_diabetes,
  max_na = 0,
  label_have_hypertension_no = c("no"),
  label_have_hypertension_yes = c("yes"),
  label_have_hypertension_unknown = c(NA, NaN),
  label_have_dyslipidemia_no = c("no"),
  label_have_dyslipidemia_yes = c("yes"),
  label_have_dyslipidemia_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{have_hypertension}{The value of variable in the parameters
\code{label_have_hypertension_no}, \code{label_have_hypertension_yes}
and \code{label_have_hypertension_unknown}.}

\item{have_dyslipidemia}{The value of variable in the parameters
\code{label_have_dyslipidemia_no}, \code{label_have_dyslipidemia_yes}
and \code{label_have_dyslipidemia_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{max_na}{Input integer 0 to 3 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}

\item{label_have_hypertension_no}{Label(s) for patient with no hypertension.
Default: \code{c("no")}}

\item{label_have_hypertension_yes}{Label(s) for patient having hypertension.
Default: \code{c("yes")}}

\item{label_have_hypertension_unknown}{Label(s) for patient
having unknown hypertension.
Default: \code{c(NA, NaN)}}

\item{label_have_dyslipidemia_no}{Label(s) for patient with no dyslipidemia.
Default: \code{c("no")}}

\item{label_have_dyslipidemia_yes}{Label(s) for patient having dyslipidemia.
Default: \code{c("yes")}}

\item{label_have_dyslipidemia_unknown}{Label(s) for patient
having unknown dyslipidemia.
Default: \code{c(NA, NaN)}}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An integer indicating the patient's risk factor index.
It can also be \code{NA} if the number of missing risk factors exceeds the \code{max_na}
input value.
}
\description{
A function used to calculate the patient's
risk factor index. This is used to calculate the likelihood
of severe coronary artery disease in the
Duke Clinical Score 1993 paper.
}
\examples{
calculate_dcs_1993_risk_factor_index(
  have_hypertension = "yes",
  have_dyslipidemia = "yes",
  have_diabetes = "no"
)

calculate_dcs_1993_risk_factor_index(
  have_hypertension = NA,
  have_dyslipidemia = "yes",
  have_diabetes = "no",
  max_na = 0
)

calculate_dcs_1993_risk_factor_index(
  have_hypertension = NA,
  have_dyslipidemia = "yes",
  have_diabetes = "no",
  max_na = 1
)
}
