% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2024_conference_ptp.R
\name{calculate_esc_2024_num_of_rf}
\alias{calculate_esc_2024_num_of_rf}
\title{Calculate Number Of Risk Factors (ESC 2024)}
\usage{
calculate_esc_2024_num_of_rf(
  have_family_history,
  have_smoking_history,
  have_dyslipidemia,
  have_hypertension,
  have_diabetes,
  max_na = 0,
  label_have_family_history_no = c("no"),
  label_have_family_history_yes = c("yes"),
  label_have_family_history_unknown = c(NA, NaN),
  label_have_smoking_history_no = c("no"),
  label_have_smoking_history_yes = c("yes"),
  label_have_smoking_history_unknown = c(NA, NaN),
  label_have_dyslipidemia_no = c("no"),
  label_have_dyslipidemia_yes = c("yes"),
  label_have_dyslipidemia_unknown = c(NA, NaN),
  label_have_hypertension_no = c("no"),
  label_have_hypertension_yes = c("yes"),
  label_have_hypertension_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{have_family_history}{The value of variable in the parameters
\code{label_have_family_history_no}, \code{label_have_family_history_yes}
and \code{label_have_family_history_unknown}.}

\item{have_smoking_history}{The value of variable in the parameters
\code{label_have_smoking_history_no}, \code{label_have_smoking_history_yes}
and \code{label_have_smoking_history_unknown}.}

\item{have_dyslipidemia}{The value of variable in the parameters
\code{label_have_dyslipidemia_no}, \code{label_have_dyslipidemia_yes}
and \code{label_have_dyslipidemia_unknown}.}

\item{have_hypertension}{The value of variable in the parameters
\code{label_have_hypertension_no}, \code{label_have_hypertension_yes}
and \code{label_have_hypertension_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{max_na}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}

\item{label_have_family_history_no}{Label(s) for patient with no family history of CAD.
Default: \code{c("no")}}

\item{label_have_family_history_yes}{Label(s) for patient having family history of CAD.
Default: \code{c("yes")}}

\item{label_have_family_history_unknown}{Label(s) for patient
having unknown family history of CAD.
Default: \code{c(NA, NaN)}}

\item{label_have_smoking_history_no}{Label(s) for patient with
no smoking history (current or past).
Default: \code{c("no")}}

\item{label_have_smoking_history_yes}{Label(s) for patient having
smoking history (current or past).
Default: \code{c("yes")}}

\item{label_have_smoking_history_unknown}{Label(s) for patient
having unknown smoking history (current or past).
Default: \code{c(NA, NaN)}}

\item{label_have_dyslipidemia_no}{Label(s) for patient with no dyslipidemia.
Default: \code{c("no")}}

\item{label_have_dyslipidemia_yes}{Label(s) for patient having dyslipidemia.
Default: \code{c("yes")}}

\item{label_have_dyslipidemia_unknown}{Label(s) for patient
having unknown dyslipidemia.
Default: \code{c(NA, NaN)}}

\item{label_have_hypertension_no}{Label(s) for patient with no hypertension.
Default: \code{c("no")}}

\item{label_have_hypertension_yes}{Label(s) for patient having hypertension.
Default: \code{c("yes")}}

\item{label_have_hypertension_unknown}{Label(s) for patient
having unknown hypertension.
Default: \code{c(NA, NaN)}}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
An integer indicating the number of risk factors the patient has.
It can also be \code{NA} if the number of missing risk factors exceeds the \code{max_na}
input value.
}
\description{
A function used to calculate the number of
risk factors the patient has. This is used to calculate the pretest
probability of coronary artery disease (CAD) based on the
ESC 2024 guidelines.
}
\examples{
calculate_esc_2024_num_of_rf(
  have_family_history = "yes",
  have_smoking_history = "yes",
  have_dyslipidemia = "yes",
  have_hypertension = "yes",
  have_diabetes = "no"
)

calculate_esc_2024_num_of_rf(
  have_family_history = "no",
  have_smoking_history = "no",
  have_dyslipidemia = "no",
  have_hypertension = NA,
  have_diabetes = "no",
  max_na = 0
)

calculate_esc_2024_num_of_rf(
  have_family_history = "no",
  have_smoking_history = "no",
  have_dyslipidemia = "no",
  have_hypertension = NA,
  have_diabetes = "no",
  max_na = 1
)
}
