% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationsfunctions.R
\name{create_patient_history_add}
\alias{create_patient_history_add}
\title{Function to simulate a single hospital bed trajectory}
\usage{
create_patient_history_add(X_los_dist, X_loi_dist, I, steps)
}
\arguments{
\item{X_los_dist}{vector of probabilities for values 1:length(dist.X.los) of X.los}

\item{X_loi_dist}{vector of probabilities for values 1:length(dist.X.loi) of X.loi}

\item{I}{incidence rate per patient-day at risk}

\item{steps}{number of days to evolve trajectory of bed}
}
\value{
data frame with following columns \itemize{
\item{pat_nbr - sequential patient number}
\item{hai_nbr - sequential HAI number}
\item{X_los -  predicted total length of stay for patient on current day}
\item{X_los_wo_hai - }
\item{X_loi - total length of current HAI}
\item{X_loi_tot - added total lengths of all HAIs up to day}
\item{A_los -  length of stay up to day}
\item{X_lnint - length of stay after acquiring first HAI}
}
}
\description{
Simulates the occupation of bed and incidence of HAIs of a single bed. 
Length of HAI is assumed to be additive to length of stay without HAI.
}
\examples{


example.dist <- create_dist_vec(function(x) dpois(x-1, 7), max.dist = 70)
example.dist.los <- create_dist_vec(function(x) dpois(x-1, lambda = 12),
                                    max.dist = 70)
bed_hist <- create_patient_history_add(example.dist.los, example.dist, I = 0.08, 1000)
tail(bed_hist)


}
