% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divfact.R
\name{ComputeDivFact}
\alias{ComputeDivFact}
\title{Compute the ratio of factorials.}
\usage{
ComputeDivFact(num, deno = NULL, out.log = FALSE)
}
\arguments{
\item{num}{The vector of all numbers which have their factorials
in the numerator.}

\item{deno}{The vector of all numbers which have their factorials
in the denominator. Default is \code{NULL}, there is only a numerator.}

\item{out.log}{Is the logarithm of the result returned instead?
Default is \code{FALSE}.}
}
\value{
The result of the ratio or its logarithm
if \code{out.log = TRUE}.
}
\description{
Compute the ratio of factorials
using Prime Factorization.
For example, ComputeDivFact(c(a, b), c(d, e, f)) computes
\eqn{\frac{a! b!}{d! e! f!}}.
}
\examples{
choose(100, 20)
ComputeDivFact(100, c(20, 80))
lchoose(100, 20)
ComputeDivFact(100, c(20, 80), out.log = TRUE)

factorial(100)
ComputeDivFact(100)
lfactorial(100)
ComputeDivFact(100, out.log = TRUE)
}
\seealso{
choose
}
