% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_tree}
\alias{plot_tree}
\title{plots a tree, optionally with colored and labeled points by taxonomic rank}
\usage{
plot_tree(
  tree,
  type = "unrooted",
  main = NULL,
  guide_size = NULL,
  rank = NULL,
  taxonomy = NULL,
  size = 2,
  legend_cutoff = 25,
  ...
)
}
\arguments{
\item{tree}{to be plotted, use layout_tree to layout tree.}

\item{type}{The type of tree to plot, default unrooted.}

\item{main}{An optional title for the plot}

\item{guide_size}{The size of the length guide.  If NULL auto detects a
reasonable size.}

\item{rank}{The rank to include, if null only the tree is plotted}

\item{taxonomy}{A data.frame with an accession field corresponding to the
tree tip labels.}

\item{size}{The size of the colored points}

\item{legend_cutoff}{The number of different taxa names after which the
names are no longer printed.}

\item{...}{additional arguments passed to \code{\link{layout_tree_ape}}}
}
\value{
plot to be printed.
}
\description{
plots a tree, optionally with colored and labeled points by taxonomic rank
}
