% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predpreyLV.R
\name{predpreyLV}
\alias{predpreyLV}
\title{The Lotka-Volterra Predator-prey Model}
\usage{
predpreyLV(t, y, params)
}
\arguments{
\item{t}{Argument for time}

\item{y}{A vector of length 2, for population 1 and 2}

\item{params}{Vector or list of parameters}
}
\value{
Returns a list of length one, for use with \code{ode} in the
\code{deSolve} package.  \item{Component 1 }{vector of the state variables,
y.}
}
\description{
The Lotka-Volterra predator-prey model, for use with \code{ode} in the
\code{deSolve} package.
}
\examples{

params1 <- c(b=.5, a=.01, s=.2, e=.1)
Time <- seq(0,100, by=.1) # Set time here
LV.out <- ode(c(H0=25,P0=5), Time, predpreyLV, params1)
matplot(Time, (LV.out[,2:3]), type="l", ylab="Population Size")

}
\references{
Lotka, A.J. (1956) \emph{Elements of Mathematical Biology}.
Dover Publications, Inc.

Stevens. M.H.H. (2009) \emph{A Primer of Ecology with R}. Use R! Series.
Springer.
}
\seealso{
\code{\link{predpreyRM}}
}
\author{
Hank Stevens <HStevens@muohio.edu>
}
\keyword{methods}
