% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negate.R
\name{clr_negate}
\alias{clr_negate}
\title{Negates colors in RGB space}
\usage{
clr_negate(col)
}
\arguments{
\item{col}{a color object or vector of any of the three kinds of R color
specifications, i.e., either a color name (as listed by colors()), a
hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see rgb), or a
positive integer i meaning palette()[i].}
}
\value{
a colors object of same length as col.
}
\description{
Negates colors in RGB space
}
\details{
The negation of color is happening in the red-green-blue colorspace
RGB. Meaning that if we take the specification for Orange which is
rgb(255, 165, 0), then we negate by taking the oppesite number on the scale
from 0 to 255, leaving us with rgb(0, 90, 255) which is a shade of blue.
}
\examples{
terr <- color(terrain.colors(10))

terr
clr_negate(terr)

plot(terr)
plot(clr_negate(terr))
}
