% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pro.R
\name{pro}
\alias{pro}
\title{Fit the PRO model}
\usage{
pro(spike, flash, ...)
}
\arguments{
\item{spike}{A binary vector represents spiking (1) or no spiking (0).}

\item{flash}{A binary vector of the same length of \code{spike}, 1 for flashing and 0 for non-flashing.}

\item{...}{Additional parameters, see \code{\link{model.pro}}.}
}
\value{
a \code{\link{glm}} object of the fitted PRO coefficients.
}
\description{
Fit the PRO model to data.
Reference: X Luo, S Gee, V Sohal, D Small (In Press). A Point-process Response Model for Optogenetics Experiments on Neural Circuits. _Statistics in Medicine_.
}
\examples{
n <- 500
set.seed(100)
re <- sim.lif(n, rbinom(n, 1, 0.14), 7, 3)
fit.pro <- pro(re$sbin, re$I)
summary(fit.pro)
}

