% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{record_pprof}
\alias{record_pprof}
\title{Profile R code and record pprof samples.}
\usage{
record_pprof(expr, seconds_timeout = Inf, pprof = tempfile(), ...)
}
\arguments{
\item{expr}{An R expression to profile.}

\item{seconds_timeout}{Maximum number of seconds of elapsed time
to profile \code{expr}. When the timeout is reached, \code{proffer} stops running
\code{expr} and returns the profiling samples taken during the
\code{seconds_timeout} time window.}

\item{pprof}{Path to a file with pprof samples.
Also returned from the function.}

\item{...}{Additional arguments passed on to \code{\link[=Rprof]{Rprof()}}.}
}
\value{
Path to a file with pprof samples.
}
\description{
Run R code and record pprof samples.
Profiles are recorded with \code{\link[=record_rprof]{record_rprof()}}
and then converted with \code{\link[=to_pprof]{to_pprof()}}.
}
\examples{
if (identical(Sys.getenv("PROFFER_EXAMPLES"), "true")) {
# Returns a path to pprof samples.
record_pprof(replicate(1e2, sample.int(1e4)))
}
}
