% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_progression_handler.R
\name{make_progression_handler}
\alias{make_progression_handler}
\title{Creates a Progression Calling Handler}
\usage{
make_progression_handler(
  name,
  reporter = list(),
  handler = NULL,
  enable = getOption("progressr.enable", interactive()),
  enable_after = getOption("progressr.enable_after", 0),
  times = getOption("progressr.times", +Inf),
  interval = getOption("progressr.interval", 0),
  intrusiveness = 1,
  clear = getOption("progressr.clear", TRUE),
  target = "terminal",
  ...
)
}
\arguments{
\item{name}{(character) Name of progression handler.}

\item{reporter}{(list) A named list of reporter functions.}

\item{handler}{(function) Function take a \link{progression} condition
as the first argument.}

\item{enable}{(logical) If FALSE, then progress is not reported.}

\item{enable_after}{(numeric) Delay (in seconds) before progression
updates are reported.}

\item{times}{(numeric) The maximum number of times this handler
should report progression updates.
If zero, then progress is not reported.}

\item{interval}{(numeric) The minimum time (in seconds) between
successive progression updates from this handler.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{clear}{(logical) If TRUE, any output, typically visual, produced
by a reporter will be cleared/removed upon completion, if possible.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Not used.}
}
\value{
A function of class \code{progression_handler} that takes a
\link{progression} condition as its first and only argument.
}
\description{
A progression calling handler is a function that takes a \link[base:conditions]{base::condition}
as its first argument and that can be use together with
\code{\link[base:conditions]{base::withCallingHandlers()}}.  This function helps creating such
progression calling handler functions.
}
\details{
The inner details of progression handlers and how to use this function
are still to be documented.  Until then, see the source code of existing
handlers for how it is used, e.g. \code{progressr::handler_txtprogressbar}.
Please use with care as things might change.
}
\section{Reporter functions}{

The \code{reporter} argument should be a named list of zero or more of the
following functions:
\itemize{
\item \code{initiate}
\item \code{update}
\item \code{finish}
}

These functions are called whenever a \link{progression} condition of type
\code{"initiate"}, \code{"update"}, or \code{"finish"} are received, but only if the
condition is for the progression that is currently handled.
These functions are called with the following arguments (in order):
\itemize{
\item \code{config} - a named list of the configuration of the progression handler:
\code{max_steps} (integer),
\code{interval} (numeric),
\code{enable_after} (numeric),
\code{auto_finish} (logical),
\code{clear} (logical),
\code{target} (character vector)
\item \code{state} - a named list of the current progress state after accounting
for the most recent \code{progression} condition:
\code{step} (integer), \code{message} (character),
\code{delta} (integer),
\code{enabled} (logical),
\code{timestamps} (POSIXct vector)
\item \code{progression} - a \link{progression} condition
\item \ldots - not used (reserved for future needs)
}

In addition to the above functions, the following functions:
\itemize{
\item \code{hide}
\item \code{unhide}
\item \code{reset}
\item \code{interrupt}
}

are called whenever the handler "should" hide or unhide the rendered
progress, or reset it, or when an interrupt is detected.  In these cases,
the \code{progression} argument is of class \code{control_progression}.
}

\examples{
## Create a progression handler that reports on the current progress
## step, the relative change, and the current progress message. This
## is only reported on positive progressions updated
my_handler <- make_progression_handler(name = "my", reporter = list(
  update = function(config, state, progression, ...) {
    if (progression$amount > 0) {
      message(sprintf("step = \%d (+\%g): message = \%s",
                      state$step,
                      progression$amount,
                      sQuote(state$message)))
    }
  }
))

handlers(my_handler)

with_progress({
  y <- slow_sum(1:5)
})

}
\seealso{
\code{\link[base:conditions]{base::withCallingHandlers()}}.
}
\keyword{internal}
