% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biproportional.R
\name{pukelsheim}
\alias{pukelsheim}
\title{Biproportional apportionment with data frames}
\usage{
pukelsheim(
  votes_df,
  district_seats_df,
  quorum,
  new_seats_col = "seats",
  weight_votes = TRUE,
  winner_take_one = FALSE,
  ...
)
}
\arguments{
\item{votes_df}{data.frame (long format) with 3 columns (actual colnames can differ):
\enumerate{
\item party id/name (character)
\item district id/name (character)
\item votes (numeric)
}}

\item{district_seats_df}{data.frame with 2 columns (actual colnames can differ):
\enumerate{
\item district id/name (character)
\item number of seats for a district (numeric)
}}

\item{quorum}{Optional list of functions which take the votes_matrix and return a logical
vector that denotes for each party/row whether they reached the quorum (i.e. are
eligible for seats). The easiest way to do this is via \code{\link[=quorum_any]{quorum_any()}} or
\code{\link[=quorum_all]{quorum_all()}}, see examples. Alternatively you can pass a precalculated logical
vector. No quorum is applied if this parameter is missing or \code{NULL}.}

\item{new_seats_col}{name of the new column}

\item{weight_votes}{By default (\code{TRUE}) it is assumed that each voter in a district has
as many votes as there are seats in a district. Set to \code{FALSE} if \code{votes_df} shows the
number of \emph{voters} (e.g. because they can only vote for one party).}

\item{winner_take_one}{Set to \code{TRUE} if the party that got the most votes in a district
must get \emph{at least} one seat ('Majorzbedingung') in this district. This only applies if
the district winnig party is entitled to a seat in the upper apportionment. Default is \code{FALSE}.}

\item{...}{ignored (available for backwards compatibility)}
}
\value{
A data.frame like \code{votes_df} with a new column denoting the number of seats per
party and district. Party and district divisors stored in attributes (hidden from print,
see \code{\link[=get_divisors]{get_divisors()}}). An ungrouped tibble is returned if \code{votes_df} is a tibble.
}
\description{
Method to proportionally allocate seats among parties/lists and
districts/regions/entities ('Doppelter Pukelsheim').
}
\details{
Each party nominates a candidate list for every district. The voters vote for the parties
of their district. The seat allocation is calculated in two steps:

\enumerate{
\item In the so called \code{\link[=upper_apportionment]{upper apportionment}}
the number of seats for each party (over all districts) is determined.
\item In the so called \code{\link[=lower_apportionment]{lower apportionment}}
the seats are distributed to the regional party list respecting the results
from the upper apportionment.
}

Parties failing to reach quorums cannot get seats. This function does not handle seat
assignment to candidates.

If you want to use other apportion methods than Sainte-Laguë use \code{\link[=biproporz]{biproporz()}}.
}
\examples{
# Zug 2018
votes_df = unique(zug2018[c("list_id", "entity_id", "list_votes")])
district_seats_df = unique(zug2018[c("entity_id", "election_mandates")])

seats_df = pukelsheim(votes_df,
                      district_seats_df,
                      quorum_any(any_district = 0.05, total = 0.03),
                      winner_take_one = TRUE)

head(seats_df)

# Finland 2019
finland19_result = pukelsheim(finland2019$votes_df,
                             finland2019$district_seats_df,
                             new_seats_col = "mandates",
                             weight_votes = FALSE)
tail(finland19_result[order(finland19_result$mandates),])

}
\seealso{
This function calls \code{\link[=biproporz]{biproporz()}} after preparing the input data.
}
