% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeFDR.R
\name{computeFDR}
\alias{computeFDR}
\title{Compute FDR given a score}
\usage{
computeFDR(score, decoy_hit, larger_better = TRUE)
}
\arguments{
\item{score}{score}

\item{decoy_hit}{indicates if decoy hit}

\item{larger_better}{is larger score the better one (default TRUE)}
}
\value{
list with decoy_hit (indicates if decoy), score the search engine score,
FDR1 false discovery rate estimated using the method of Gygi, SimpleFDR - estimated using the method of Kaell.
}
\description{
Same as computeFDRwithID but works with decoy_hit boolean vector.
For more details and references see package vignette
\code{vignette("TargetDecoyFDR_Example", package = "prozor")}
}
\examples{
data(fdrSample)

fdr1 <- computeFDR(fdrSample$score, grepl("REV_",fdrSample$proteinID), larger_better = FALSE)
head(as.data.frame(fdr1))

}
