% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_modify_recode.R
\name{code_modify_recode}
\alias{code_modify_recode}
\title{Code modify recode. To be called by harmonization function.}
\usage{
code_modify_recode(
  data = temp_dataset,
  instruction = code_instruct,
  old_var = source_item_long,
  new_var = item,
  na_string = NULL
)
}
\arguments{
\item{data}{Dataframe to be modified}

\item{instruction}{Coding instruction from harmonization sheet}

\item{old_var}{Name of original variable}

\item{new_var}{Name of new variable}

\item{na_string}{Character string of final recode value to be set to NA.}
}
\value{
Returns vector of new variable after recoding as needed.
}
\description{
Code modify recode. To be called by harmonization function.
}
\examples{

test_data <- data.frame(val = c('a','b','c','d'))

code_modify_recode(data = test_data,
  instruction = 'a = apple; c = carrot', old_var = 'val', new_var = 'new')

}
