% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geelm.R
\name{geelm}
\alias{geelm}
\title{Generalized Estimating Equation with Gaussian family}
\usage{
geelm(
  formula,
  data,
  subset,
  id,
  link = c("identity", "log", "cloglog", "logit"),
  corstr = c("independence", "exchangeable", "ar1"),
  lambda,
  exclude,
  penalty = c("lasso", "scad"),
  nfolds = 5,
  nlambda = 200,
  binit,
  tol = 1e-07,
  maxit = 100
)
}
\arguments{
\item{formula}{A formula object starting with \code{~} for the model formula.}

\item{data}{An optional data frame that contains the covariates and response variables.}

\item{subset}{An optional logical vector specifying a subset of
observations to be used in the fitting process.}

\item{id}{A vector which identifies the clusters.
If not specified, each observation is treated as its own cluster.}

\item{link}{A character string specifying the model link function. Available options are
\code{"identity"}, \code{"log"}, \code{"cloglog"}, and \code{"logit"}.}

\item{corstr}{A character string specifying the correlation structure.
Available options are \code{"independence"}, \code{"exchangeable"}, and \code{"ar1"}.}

\item{lambda}{An option for specifying the tuning parameter used in penalization.
When this is unspecified or has a \code{NULL} value,
penalization will not be applied and \code{pCure()} will uses all covariates
specified in the formulas.
Alternatively, this can be specified as a vector numeric vector of non-negative values
or "auto" for auto selection.}

\item{exclude}{A binary numerical vector specifying which variables to exclude in variable selection.
The length of \code{exclude} must match with the number of covariates.
A value of 1 means to exclude in the variable selection.}

\item{penalty}{A character string specifying the penalty function.
The available options are \code{"lasso"} and \code{"scad"}.}

\item{nfolds}{An optional integer value specifying the number of folds.
The default value is 5.}

\item{nlambda}{An optional integer value specifying the number of tuning parameters to try
if \code{lambda = "auto"}.}

\item{binit}{A optional numerical vector for the initial value.
A zero vector is used when not specified.}

\item{tol}{A positive numerical value specifying the absolute
error tolerance in root search. Default at \code{1e-7}.}

\item{maxit}{A positive integer specifying the maximum number of iteration.
Default at 100.}
}
\value{
An object of class \code{"geelm"} representing a linear model fit with GEE.
}
\description{
Fits a generalized estimating equation (GEE) model with
Gaussian family with different link functions.
The \code{geelm} function also supports LASSO or SCAD
regularization.
}
\examples{
gendat <- function() {
  id <- gl(50, 4, 200)
  visit <- rep(1:4, 50)
  x1 <- rbinom(200, 1, 0.6)
  x2 <- runif(200, 0, 1)
  phi <- 1 + 2 * x1
  rhomat <- 0.667^outer(1:4, 1:4, function(x, y) abs(x - y))
  chol.u <- chol(rhomat)
  noise <- as.vector(sapply(1:50, function(x) chol.u \%*\% rnorm(4)))
  e <- sqrt(phi) * noise
  y <- 1 + 3 * x1 - 2 * x2 + e
  dat <- data.frame(y, id, visit, x1, x2)
  dat
}

set.seed(1); str(dat <- gendat())
geelm(y ~ x1 + x2, id = id, data = dat, corstr = "ar1")
}
