% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3method.R
\name{psrank}
\alias{psrank}
\title{Calculation of Pseudo-Ranks (Deprecated)}
\usage{
psrank(x, ...)
}
\arguments{
\item{x}{vector containing the observations}

\item{...}{further arguments (see help for pseudorank)}
}
\value{
Returns a numerical vector containing the pseudo-ranks.
}
\description{
Calculation of (mid) pseudo-ranks of a sample. In case of ties (i.e. equal values), the average of min pseudo-ranks and max-pseudo-ranks are taken (similar to rank with ties.method="average").
}
\examples{
df <- data.frame(data = round(rnorm(100)), group = c(rep(1,40),rep(2,40),rep(3,20)))
df$group <- as.factor(df$group)

## two ways to calculate pseudo-ranks

# Variant 1: use a vector for the data and a group vector
pseudorank(df$data,df$group)

# Variant 2: use a formula object, Note that only one group factor can be used
# that is, in data~group*group2 only 'group' will be used
pseudorank(data~group,df)
}
\references{
Happ M, Zimmermann G, Brunner E, Bathke AC (2020). Pseudo-Ranks: How to Calculate Them Efficiently in R. Journal of Statistical Software, Code Snippets, *95*(1), 1-22. doi: 10.18637/jss.v095.c01 (URL:https://doi.org/10.18637/jss.v095.c01).
}
\keyword{export}
