% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfmi_mm_multiparm.R
\name{psfmi_mm_multiparm}
\alias{psfmi_mm_multiparm}
\title{Multiparameter pooling methods called by psfmi_mm}
\usage{
psfmi_mm_multiparm(
  data,
  nimp,
  impvar,
  Outcome,
  P,
  p.crit,
  family,
  random.eff,
  method,
  print.method
)
}
\arguments{
\item{data}{Data frame with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the
dataset. The imputed datasets must be distinguished by an imputation variable,
specified under impvar, and starting by 1 and the clusters should be 
distinguished by a cluster variable, specified under clusvar.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the
imputed datasets.}

\item{Outcome}{Character vector containing the name of the outcome variable.}

\item{P}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined.}

\item{p.crit}{A numerical scalar. P-value selection criterium. A value of 1 
provides the pooled model without selection.}

\item{family}{Character vector to specify the type of model, "linear" is used to 
call the \code{lmer} function and "binomial" is used to call the \code{glmer}
function of the \code{lme4} package. See details for more information.}

\item{random.eff}{Character vector to specify the random effects as used by the 
\code{lmer} and \code{glmer} functions of the \code{lme4} package.}

\item{method}{A character vector to indicate the pooling method for p-values to pool the
total model or used during predictor selection. This can be "D1", "D2", "D3" or "MPR".
See details for more information.}

\item{print.method}{logical vector. If TRUE full matrix with p-values of 
all variables according to chosen method (under method) is shown. If FALSE (default) 
p-value for categorical variables according to method are shown and for continuous 
and dichotomous predictors Rubin’s Rules are used.}
}
\description{
\code{psfmi_mm_multiparm} Function to pool according to D1, D2 and D3 methods
}
\examples{

\dontrun{
 psfmi_mm_multiparm(data=ipdna_md, nimp=5, impvar=".imp", family="linear",
 P=c("gender", "bnp", "dbp", "lvef", "bmi_cat"),
 random.eff="( 1 | centre)", Outcome="sbp",
 p.crit=0.05, method="D1", print.method = FALSE)
}

}
