% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likepsm.R
\name{compare_psm_likes}
\alias{compare_psm_likes}
\title{Compare likelihoods of PSMs}
\usage{
compare_psm_likes(ptdata, fitslist, cuttime = 0)
}
\arguments{
\item{ptdata}{Dataset of patient level data. Must be a tibble with columns named:
\itemize{
\item ptid: patient identifier
\item pfs.durn: duration of PFS from baseline
\item pfs.flag: event flag for PFS (=1 if progression or death occurred, 0 for censoring)
\item os.durn: duration of OS from baseline
\item os.flag: event flag for OS (=1 if death occurred, 0 for censoring)
\item ttp.durn: duration of TTP from baseline (usually should be equal to pfs.durn)
\item ttp.flag: event flag for TTP (=1 if progression occurred, 0 for censoring).
}}

\item{fitslist}{List of distribution fits to relevant endpoints, after calling \code{fit_ends_mods_par()} or \code{fit_ends_mods_spl()}}

\item{cuttime}{Time cutoff - this is nonzero for two-piece models.}
}
\value{
List containing
\itemize{
\item \code{results}: Dataset of calculation results for each model
\item \code{bests}: Tibble indicating which is the best fitting model individually or jointly, to each endpoint, according to AIC or BIC
}
}
\description{
Compare the total log-likelihood values for the patient-level dataset after fitting PSM-simple and PSM-complex models to each combination of endpoint distributions
}
\examples{
# Fit parametric distributions to a dataset
bosonc <- create_dummydata("flexbosms")
parfits <- fit_ends_mods_par(bosonc)
\donttest{
splfits <- fit_ends_mods_spl(bosonc)
# Present comparison of likelihood calculations
compare_psm_likes(bosonc, parfits)
compare_psm_likes(bosonc, splfits)
}
}
