% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_mvrr.R
\name{correct_means_mvrr}
\alias{correct_means_mvrr}
\title{Multivariate select/correction for vectors of means}
\usage{
correct_means_mvrr(
  Sigma,
  means_i = rep(0, ncol(Sigma)),
  means_x_a,
  x_col,
  y_col = NULL,
  var_names = NULL
)
}
\arguments{
\item{Sigma}{The complete covariance matrix to be used to manipulate means: This matrix may be entirely unrestricted or entirely range restricted,
as the regression weights estimated from this matrix are expected to be invariant to the effects of selection.}

\item{means_i}{The complete range-restricted (unrestricted) vector of means to be corrected (selected upon).}

\item{means_x_a}{The vector of unrestricted (range-restricted) means of selection variables}

\item{x_col}{The row/column indices of the variables in \code{Sigma} that correspond, in order, to the variables in means_x_a}

\item{y_col}{Optional: The variables in \code{Sigma} not listed in \code{x_col} that are to be manipulated by the multivariate range-restriction formula.}

\item{var_names}{Optional vector of names for the variables in \code{Sigma}, in order of appearance in the matrix.}
}
\value{
A vector of means that has been manipulated by the multivariate range-restriction formula.
}
\description{
Correct (or select upon) a vector of means using principles from the Pearson-Aitken-Lawley multivariate selection theorem.
}
\examples{
Sigma <- diag(.5, 4)
Sigma[lower.tri(Sigma)] <- c(.2, .3, .4, .3, .4, .4)
Sigma <- Sigma + t(Sigma)
diag(Sigma) <- 1
correct_means_mvrr(Sigma = Sigma, means_i = c(.3, .3, .1, .1),
means_x_a = c(-.1, -.1), x_col = 1:2)
}
\references{
Aitken, A. C. (1934). Note on selection from a multivariate normal population.
\emph{Proceedings of the Edinburgh Mathematical Society (Series 2), 4}(2), 106–110.

Lawley, D. N. (1943). A note on Karl Pearson’s selection formulae.
\emph{Proceedings of the Royal Society of Edinburgh. Section A. Mathematical and Physical Sciences, 62}(1), 28–30.
}
