% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt_examples.R
\name{pt_ex_nums}
\alias{pt_ex_nums}
\title{Quick ptables for numeric variables}
\usage{
pt_ex_nums(parity = TRUE, separation = FALSE)
}
\arguments{
\item{parity}{a scalar logical; if \code{TRUE}, a single ptable will be generated.
If \code{FALSE}, two ptables for even and odd numbers are created}

\item{separation}{a scalar logical; if \code{TRUE}, an additional ptable with
variance \code{1} will be returned that is designed to perturb small cell values}
}
\value{
Returns a \linkS4class{ptable} object if both \code{parity} and \code{separation}
are \code{FALSE}, else a named list.
}
\description{
\code{\link[=pt_ex_nums]{pt_ex_nums()}} returns a perturbation table objects from
\code{\link[=create_num_ptable]{create_num_ptable()}} with some default parameters. This is useful
for quickly creating ptables to demonstrate usage in other tools.
}
\examples{
\donttest{
# extra ptable for small cells
names(pt_ex_nums(parity = FALSE, separation = TRUE))

# different ptables for even/odd cells
names(pt_ex_nums(parity = TRUE, separation = TRUE))
}
}
