% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptable_pkg.R
\name{create_ptable}
\alias{create_ptable}
\alias{create_cnt_ptable}
\alias{create_cnts_ptable}
\alias{create_num_ptable}
\alias{create_nums_ptable}
\title{Noise Probability Generator for the Cell-Key Method (CKM)}
\usage{
create_ptable(
  D,
  V,
  js = 0,
  pstay = NULL,
  optim = 1,
  mono = TRUE,
  step = 1,
  icat = NULL,
  table = "cnts",
  type = "all",
  label = paste0("D", D, "V", V * 100),
  monitoring = FALSE,
  debugging = FALSE,
  create = TRUE,
  params = NULL
)

create_cnt_ptable(
  D,
  V,
  js = 0,
  pstay = NULL,
  optim = 1,
  mono = TRUE,
  label = paste0("D", D, "V", V * 100),
  monitoring = FALSE,
  create = TRUE
)

create_num_ptable(
  D,
  V,
  pstay = NULL,
  optim = 1,
  mono = TRUE,
  step = 2,
  icat = NULL,
  type = "all",
  label = paste0("D", D, "V", V * 100),
  monitoring = FALSE,
  create = TRUE
)
}
\arguments{
\item{D}{perturbation parameter for maximum noise (scalar integer)}

\item{V}{perturbation parameter for variance (scalar double)}

\item{js}{threshold value for blocking of small frequencies
(i.e. the perturbation will not produce positive cell values that are equal
to or smaller than the threshold value). (scalar integer)}

\item{pstay}{optional parameter to set the probability (0 < p < 1) of
an original frequency to remain unperturbed: NA (default) no preset
probability (i.e. produces the maximum entropy solution)}

\item{optim}{optimization parameter: \code{1} standard approach (default) with
regular constraints, \code{4} alternative approach with simplified constraints
(may work if constraints using the standard approach are violated)}

\item{mono}{(logical) vector specifying optimization parameter for
monotony condition}

\item{step}{(integer) number of steps for the noise (between two integer
values). Whereas the cell-key approach
for frequency count tables only allows to have noise values that are
integers (\code{step = 1})
\deqn{-D, 1-D, 2-D, ..., -1, 0, 1, ..., D-2, D-1, D}
the noise distribution for magnitude values does not have
to be integer valued:
\deqn{-D, (1/step)-D, (2/step)-D, ..., 0, ..., D-(2/step), D-(1/step), D}
The reciprocal of step (='step width') is computed and used internally
for the perturbation table.}

\item{icat}{(integer) categorized original frequencies i}

\item{table}{(character) type of the table: frequency count (\code{cnts})
or magnitude table (\code{nums})}

\item{type}{(character) type indicator for the extra column 'type' used for
magnitude tables: \code{'even'}, \code{'odd'} or \code{'all'} (default)}

\item{label}{(character) label of the Output}

\item{monitoring}{(logical) output monitoring on/off}

\item{debugging}{(logical) debug monitoring on/off}

\item{create}{(logical) scalar specifying to create just the
input parameters of class \linkS4class{ptable_params} (\code{FALSE}) or also to
create the perturbation table object of class \linkS4class{ptable}
(default: \code{TRUE})}

\item{params}{object of class \linkS4class{ptable_params} can be used as input
instead of the remaining parameters}
}
\value{
Returns \linkS4class{ptable} object including the
created perturbation table by default. If the argument \code{create = FALSE},
a \linkS4class{ptable_params} object is returned.
}
\description{
\href{https://github.com/sdcTools/ptable}{ptable} makes it easy to create
perturbation tables that can be used for applying noise to statistical
tables with any cell-key method approach - among others either the
\href{https://github.com/sdcTools/cellKey}{cellKey()}-package
or the standalone tool \href{https://github.com/sdcTools/tauargus}{TauArgus}.

The package
provides four main functions to create the perturbation tables:
\itemize{
\item \code{create_ptable()}: generic function that creates a ptable, either for
frequency count or magnitude tables with a various set of options.
\item \code{create_cnt_ptable()}: creates a ptable suitable for frequency count
tables.
\item \code{create_num_ptable()}: creates a ptable suitable for magnitude tables
(i.e. with numerical variables).
\item \code{\link[=modify_cnt_ptable]{modify_cnt_ptable()}}: modifies the ptable for a higher level of protection
}
}
\details{
The perturbation probabilities are constructed given the following
constraints:
\itemize{
\item Maximum noise
\item Zero mean (unbiased noise)
\item Fixed noise variance
\item Transition probabilities are between zero and one and the sum up to 1
\item Perturbations will not produce negative cell values or positive cell values
equal to or less than a specific threshold value
}
}
\examples{

# create ptable for frequency count tables
create_cnt_ptable(D = 3, V = 1.08, js = 1, label = "ptable_frequency_tab")

# create ptable for magnitude tables
create_num_ptable(D = 5, V = 2, step = 4, icat = c(1, 3, 5))
\donttest{
# create ptable for frequency or magnitude tables
create_ptable(D = 3, V = 1.08, js = 1, table="cnts")
create_ptable(D = 5, V = 2, step = 4, icat = c(1, 4, 5), table="nums")
}

}
\seealso{
\itemize{
\item \code{\link[=plot]{plot()}} to analyze the created perturbation table visually
\item \code{\link[=pt_export]{pt_export()}} to export the perturbation table for external sdcTools
like \href{https://github.com/sdcTools/tauargus}{TauArgus} or SAS.
}
}
