% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pte_params.R
\name{setup_pte}
\alias{setup_pte}
\title{Generic Setup Function}
\usage{
setup_pte(
  yname,
  gname,
  tname,
  idname,
  data,
  required_pre_periods = 1,
  anticipation = 0,
  base_period = "varying",
  cband = TRUE,
  alp = 0.05,
  boot_type = "multiplier",
  weightsname = NULL,
  gt_type = "att",
  ret_quantile = 0.5,
  biters = 100,
  cl = 1,
  call = NULL,
  ...
)
}
\arguments{
\item{yname}{Name of outcome in \code{data}}

\item{gname}{Name of group in \code{data}}

\item{tname}{Name of time period in \code{data}}

\item{idname}{Name of id in \code{data}}

\item{data}{balanced panel data}

\item{required_pre_periods}{The number of required pre-treatment periods to implement
the estimation strategy.  Default is 1.}

\item{anticipation}{how many periods before the treatment actually takes
place that it can have an effect on outcomes}

\item{base_period}{The type of base period to use.  This only affects
the numeric value of results in pre-treatment periods.  Results in
post-treatment periods are not affected by this choice.  The default
is "varying", where the base period will "back up" to the immediately
preceding period in pre-treatment periods.  The other option is "universal"
where the base period is fixed in pre-treatment periods to be the period
right before the treatment starts.  "Universal" is commonly used in
difference-in-differences applications, but can be unnatural for other
identification strategies.}

\item{cband}{whether or not to report a uniform (instead of pointwise)
confidence band (default is TRUE)}

\item{alp}{significance level; default is 0.05}

\item{boot_type}{which type of bootstrap to use}

\item{weightsname}{The name of the column that contains sampling weights.
The default is NULL, in which case no sampling weights are used.}

\item{gt_type}{which type of group-time effects are computed.
The default is "att".  Different estimation strategies can implement
their own choices for \code{gt_type}}

\item{ret_quantile}{For functions that compute quantile treatment effects,
this is a specific quantile at which to report results, e.g.,
\code{ret_quantile = 0.5} will return that the qte at the median.}

\item{biters}{number of bootstrap iterations; default is 100}

\item{cl}{number of clusters to be used when bootstrapping; default is 1}

\item{call}{keeps track of through the \code{call} from external functions/packages}

\item{...}{additional arguments}
}
\value{
\code{pte_params} object
}
\description{
This is a function for how to setup
the data to be used in the \code{ptetools} package.

The \code{setup_pte} function builds on \code{setup_pte_basic} and
attempts to provide a general purpose function (with error handling)
to arrange the data in a way that can be processed by \code{subset_fun}
and \code{attgt_fun} in the next steps.
}
