% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{buff_sp}
\alias{buff_sp}
\title{Creates buffer of sp polygon object}
\usage{
buff_sp(area, radius, dissolve = TRUE)
}
\arguments{
\item{area}{SpatialPolygon or SpatialPolygonDataFrame that defines the area}

\item{radius}{scaler for the size of the buffer (in whatever units the polygon is projected in)}

\item{dissolve}{boolean (default TRUE), to dissolve into single object, or leave as multiple objects}
}
\value{
A SpatialPolygonDataFrame object (when dissolve=FALSE), or a SpatialPolygon object (when dissolve=TRUE)
}
\description{
Creates buffer of sp polygon object. Intended to replace raster::buffer, which relies on rgeos
}
\details{
Under the hood, this converts sp objects into sf objects and uses \code{st_buffer}.
When \code{dissolve=TRUE}, it uses \code{st_union(area)} and then buffers.
}
\examples{
\donttest{
library(sp) #for sp plot methods
# large grid cells
data(nyc_bor)
res <- buff_sp(nyc_bor,7000)
plot(nyc_bor)
plot(res,border='BLUE',add=TRUE)

# When dissolve=FALSE, still returns individual units
# that can overlap
res2 <- buff_sp(nyc_bor,7000,dissolve=FALSE)
plot(res2)
}
}
