% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesfun.R
\name{likelihood0}
\alias{likelihood0}
\title{Default likelihood function}
\usage{
likelihood0(
  param,
  y = y,
  parseparam = parseparam0,
  N = 1000,
  detfun = detfun0,
  edmdat = NULL,
  obsfun = obsfun0,
  procfun = procfun0,
  neff = FALSE,
  lowerbound = (-999)
)
}
\arguments{
\item{param}{An unformatted vector of parameters, to be passed to parseparam function.}

\item{y}{A numeric vector of observed values, from which the likelihood of parameters and functions will be determined.}

\item{parseparam}{A function for transforming the vector param into a form that can be read by particleFilterLL. See particleFilterLL for details.}

\item{N}{Number of particles to simulate. Defaults to 1e3.}

\item{detfun}{A function that simulates deterministic dynamics, which takes in arguments sdet (parameters for deterministic model, taken from pars$proc), and xt, observed abundances at time t.
Returns estimated abundances at time t+1 based on deterministic function (either a parametric function or an EDM function). Defaults to detfun0.}

\item{edmdat}{A list including arguments to be passed to S_map_Sugihara1994 - see S_map_Sugihara1994 help file for details. Alternatively, the user can provide a matrix of pre-computed S-map coefficients, in element "smp_cf".
Default for edmdat is NULL, which implies that EDM will not be applied - instead, a detfun and pars$det must be included.}

\item{obsfun}{The observation error function to be used: defaults to obsfun0}

\item{procfun}{The process noise function to be used: defaults to procfun0}

\item{neff}{Should effective sample size be used to scale likelihood? Defaults to FALSE. TRUE uses automatic sample size, based on correlations in y. Otherwise, can be any positive number.}

\item{lowerbound}{Lower bound for log likelihood. Filter will be re-run if the value falls below this threshold. NOTE - this option may induce a bias
in the resulting likelihood (and subsequent parameter) estimates. Should only be set if the lower limit is indicative of filter failure (e.g. if all particles)
are degenerate. Defaults to (-Inf) - i.e. no lower limit.}
}
\value{
Log likelihood generated by particleFilterLL function
}
\description{
Calculates likelihood of vector y given parameter values in param, based on the particleFilterLL function.
}
\keyword{MCMC}
\keyword{optimization}
\keyword{stability}
\keyword{time-series}
