% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uds.R
\docType{data}
\name{uds}
\alias{uds}
\title{Urine Drug Screening (UDS) Results}
\format{
A tibble with 42,906 rows and
3 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{what}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Alcohol) \cr
    \tab  \cr
   \emph{Description:} \tab Name of drug identified \cr
    \tab  \cr
   \emph{Levels:} \tab Alcohol, Amphetamine, Benzodiazepine, Buprenorphine, Cocaine, Mdma/Hallucinogen, Methadone, Opioid, Sedatives, Thc \cr
}


}
\item{\strong{when}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Study day \cr
}


}
}
}
\usage{
data(uds)
}
\description{
UDS findings. Note that oxycodone and propoxyphene are grouped
into the opioid category. ctn_0051 did not specifically screen for
propoxyphene.  For details on substances screened, see the vignette
\href{../doc/harmonization.html#uds}{Harmonization Information}.
}
\keyword{datasets}
