% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateCTN30ProtocolHistory.R
\name{CreateCTN30ProtocolHistory}
\alias{CreateCTN30ProtocolHistory}
\title{Create a Subject History Table by Protocol}
\usage{
CreateCTN30ProtocolHistory(
  randCTN30_df,
  start_int = -30,
  phase1Len_int = 98,
  phase2Len_int = 168
)
}
\arguments{
\item{randCTN30_df}{A data frame of subject randomization days for CTN-0030.
This data will have columns for \code{who}, \code{which}, and \code{when}.}

\item{start_int}{When should the protocol timeline start? Defaults to 30 days
before consent (allowing for self-reported drug use via Timeline Follow-
Back data).}

\item{phase1Len_int}{When should Phase I end per protocol? Defaults to 98
days (14 weeks).}

\item{phase2Len_int}{When should Phase II end per protocol? Defaults to 168
days (24 weeks).}
}
\value{
A tibble with columns \code{who} and \code{when}. Each subject will
have one row for each day in the study range.
}
\description{
Create a Subject History Table by Protocol
}
\details{
We may want to perform SQL-like operations on a set of tables. This
data table will form the "backbone" for future join operations. It creates
one record per person in a study for each day in that study, and it is
designed to work with subject-specific two-arm protocols (where Phase I
and Phase II treatments could start on different days for each subject).
For subjects who consented to treatment but were never randomized, we use
an "intent to treat" philosophy and assign them an empty protocol timeline
starting on the day of consent (day 0) until \code{phase1Len_int}.

NOTE: We expect this function to be used specifically to create a
potential visit backbone for CTN-0030. For studies with fixed protocol
lengths, please use \code{CreateSubjectHistory()} instead.
}
\examples{
   # Subject A started Phase I on day 2 and was switched from treatment
   #   Phase I to Phase II on day 45. Subject B started Phase I on day 6 and
   #   was never switched to Phase II (either because they dropped out of the
   #   study or because the treatment given to them in Phase I worked).
   rand_df <- data.frame(
     who   = c("A", "A", "B", "B"),
     which = c(  1,   2,   1,   2),
     when  = c(  2,  45,   6,  NA)
   )

   # Based on this example data above, we expect to see potential contact
   #   days per the protocol for subject A to range from -30 to 45 + 168.
   #   For subject B, we expect this range to be from -30 to 6 + 98
   CreateCTN30ProtocolHistory(rand_df)

}
