% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_topology.R
\name{check_topology}
\alias{check_topology}
\title{Check if the topology is valid.}
\usage{
check_topology(topology)
}
\arguments{
\item{topology}{the topology as a \link[tibble]{tibble}
with the columns 'name' and 'topology',
where the 'name' column hold all the proteins' names,
and 'topology' contains the respective topologies as strings.}
}
\value{
Nothing. Will \link{stop} with a helpful error message if
the topology is invalid.
}
\description{
Check if the argument is of the same type as a predicted topology,
as can be created with \link{predict_topology}.
Will \link{stop} if not.
}
\examples{
if (is_pureseqtm_installed()) {
  fasta_filename <- get_example_filename("1bhaA.fasta")
  topology <- predict_topology(fasta_filename)
  check_topology(topology)
}
}
\author{
Richèl J.C. Bilderbeek
}
