% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cancel_retries.R
\name{cancel_retries}
\alias{cancel_retries}
\title{Cancel retries for an emergency priority notification}
\usage{
cancel_retries(receipt, app = get_pushover_app())
}
\arguments{
\item{receipt}{The receipt from sending an emergency message}

\item{app}{application token (see \code{\link[=set_pushover_app]{set_pushover_app()}})}
}
\value{
an invisible list containing the following fields:
\itemize{
\item \code{status}: request status (1 = success)
\item \code{request}: unique request ID
\item \code{errors}: a list of error messages (only for unsuccessful requests)
\item \code{raw}: the raw \link[httr:response]{httr::response} object
}
}
\description{
\code{cancel_retries()} stops Pushover from sending repeat messages for
un-acknowledged emergency priority notifications.
}
\examples{
\dontrun{
msg1 <- pushover_emergency(message = "Test emergency message")
cancel_retries(receipt = msg1$receipt)
}
}
