% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_pushover_user.R
\name{set_pushover_user}
\alias{set_pushover_user}
\alias{get_pushover_user}
\alias{unset_pushover_user}
\alias{set_pushover_group}
\alias{get_pushover_group}
\alias{unset_pushover_group}
\title{Set, get, and unset the Pushover user/group key}
\usage{
set_pushover_user(user = NULL, ask = is_interactive())

get_pushover_user(ask = is_interactive())

unset_pushover_user()

set_pushover_group(user = NULL, ask = is_interactive())

get_pushover_group(ask = is_interactive())

unset_pushover_group()
}
\arguments{
\item{user}{The user or group key to be used. If none is provided, a prompt
will request the key.}

\item{ask}{Whether or not to ask for the key if none is provided. Note that
this only works for interactive sessions.}
}
\value{
\code{get_pushover_user()} returns a string containing the current
user or group key or an empty string if not set. If the user is not set but
\code{ask} is \code{TRUE}, the user will be prompted for a key.
}
\description{
\code{set_pushover_user()} sets the Pushover user or group key to be used in
subsequent commands, \code{get_pushover_user()} gets the user or group key
that is currently set, and \code{unset_pushover_user()} unsets the key.
}
\details{
\code{set_pushover_group()}, \code{get_pushover_group()}, and
\code{unset_pushover_group()} are aliases for these functions.

\code{set_pushover_user()} only sets the Pushover user or group for the current
session. If a different value is specified in \code{.Renviron}, that value will be
used in future sessions. Similarly, \code{unset_pushover_user()} will only
unset the user or group for the current session.

User keys can be found within the settings of the Pushover app or
by logging in to \url{https://pushover.net}. Group keys can be found after
creating a delivery group in your account on \url{https://pushover.net}.
}
\examples{
\dontrun{
set_pushover_user(user = "uQiRzpo4DXghDmr9QzzfQu27cmVRsG")
}
}
