% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/da_object_oriented_functions.R
\name{da}
\alias{da}
\title{Disproportionality Analysis}
\usage{
da(
  df = NULL,
  df_colnames = list(report_id = "report_id", drug = "drug", event = "event", group_by =
    NULL),
  da_estimators = c("ic", "prr", "ror"),
  sort_by = "ic",
  number_of_digits = 2,
  rule_of_N = 3,
  conf_lvl = 0.95,
  excel_path = NULL
)
}
\arguments{
\item{df}{An object possible to convert to a data table, e.g.
a tibble or data.frame, containing patient level reported drug-event-pairs.
See header 'The df object' below for further details.}

\item{df_colnames}{A list of column names to use in \code{df}. That is,
point \code{da} to the 'report id'-column (\code{report_id}), the
'drug name'-column (\code{drug}), the 'adverse event'-column (\code{event})
and optionally a grouping column \code{group_by} to calculate disproportionality
across. See the vignette for further details.}

\item{da_estimators}{Character vector specifying which disproportionality
estimators to use, in case you don't need all implemented options. Defaults
to c("ic", "prr", "ror").}

\item{sort_by}{The output is sorted in descending order of the lower bound of
the confidence/credibility interval for a passed da estimator. Any of the passed strings
in "da_estimators" is accepted, the default is "ic".
If a grouping variable is passed, sorting is made by the sample average across each drug-event-combination (ignoring NAs).}

\item{number_of_digits}{Round decimal columns to specified precision, default is two decimals.}

\item{rule_of_N}{Numeric value. Sets estimates for ROR and PRR to NA when observed
counts are strictly less than the passed value of \code{rule_of_N}. Default value
is 3, 5 is sometimes used as a more liberal alternative. Set to NULL if you
don't want to apply any such rule.}

\item{conf_lvl}{Confidence level of confidence or credibility intervals.
Default is 0.95 (i.e. 95 \% confidence interval).}

\item{excel_path}{Intended for users who prefer to work in excel with minimal work in R.
To write the output of \code{da} to an excel file, provide a path
to a folder. For instance, to write to your current working directory, pass \code{getwd()}.
 The excel file will by default be named \code{da.xlsx}. To control the excel file name,
 pass a path ending with the desired filename suffixed with \code{.xlsx}. If you
 do not want to export the output to an excel file, pass NULL (the default).}
}
\value{
\code{da} returns a data frame (invisibly) containing counts and
estimates related to supported disproportionality estimators. Each row
corresponds to a drug-event pair.
}
\description{
The function \code{da} executes disproportionality analyses,
i.e. compares the proportion of reports with a specific adverse event for a drug,
against an event proportion from a comparator based on the passed data frame.
See the vignette for a brief introduction to disproportionality analysis.
Furthermore, \code{da} supports three estimators: Information Component (IC),
Proportional Reporting Rate (PRR) and the Reporting Odds Ratio (ROR).
}
\section{The df object}{

 The passed \code{df} should be (convertible to) a data table and at least contain three
 columns: \code{report_id}, \code{drug} and \code{event}. The data table should contain one row
 per reported drug-event-combination, i.e. receiving a single additional report
 for drug X and event Y would add one row to the table. If the single report
 contained drug X for event Y and event Z, two rows would be added, with the
 same \code{report_id} and \code{drug} on both rows. Column \code{report_id} must be of type
 numeric or character. Columns \code{drug} and \code{event} must be of type character.
 If column \code{group_by} is provided, it can be either numeric or character.
 You can use a \code{df} with column names of your choosing, as long as you
 connect role and name in the \code{df_colnames}-parameter.
}

\examples{
\donttest{
### Run a disproportionality analysis

da_1 <-
  tiny_dataset |>
  da()

### Run a disproportionality across subgroups
list_of_colnames <-
  list(
    report_id = "report_id",
    drug = "drug",
    event = "event",
    group_by = "group"
  )

 da_2 <-
  tiny_dataset |>
  da(df_colnames = list_of_colnames)

# If columns in your df have different names than the default ones,
# you can specify the column names in the df_colnames parameter list:

renamed_df <-
  tiny_dataset |>
  dplyr::rename(ReportID = report_id)

list_of_colnames$report_id <- "ReportID"

da_3 <-
  renamed_df |>
  da(df_colnames = list_of_colnames)
}

}
