#' Pressure volume curve data
#'
#' A dataset containing water potential and fresh weight measurements of repeatedly measured drying kohlrabi leaves subjected to
#' different soil moisture conditions during their growth (n = 6) and their saturated fresh weight and dry weight.
#'
#' \itemize{
#'   \item date: Date of measurement
#'   \item treatment: Soil moisture conditions during the last 6 days of Kohlrabi growth (10-30 % (10 %) or 40-60 % (40 %))
#'   \item sample: Sample ID (1 - 12)
#'   \item fresh.weight.harvest: Fresh weight measured at harvest (12 h prior measurement of fresh.weight.saturated) (2.9813 - 7.1557)
#'   \item fresh.weight.saturated: Saturated fresh weight of the leaf in gramms (4.1276 - 7.0867)
#'   \item fresh.weight: Fresh weight of the leaf in gramms (2.7215 - 6.8246)
#'   \item dry.weight: Dry weight of the leaf in gramms (0.2937 - 0.7267)
#'   \item water.potential: Water potential of the leaf in bar (-16.2 - -2.4)
#' }
#' @format A data frame with 160 rows and 8 variables
"pressure_volume_data"
