% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeatherAllocation.R
\name{WeatherAllocation}
\alias{WeatherAllocation}
\title{Weather Allocation}
\usage{
WeatherAllocation(weight_loss_data, weather_data)
}
\arguments{
\item{weight_loss_data}{data frame containing at least a column named "date.and.time" of the
class POSIXct with the time (and date) of the measuring events. A column named "sample"
containing the sample IDs is optionally required if several samples were measured.}

\item{weather_data}{data frame containing at least a column named "date.and.time" of the
class POSIXct with the time (and date) of the weather measurements and two columns
named "humidity" and "temperature" containing the numerical weather data}
}
\value{
The original weight loss data frame extended by the approximatively integrated and
normalized weather data for each period between two weight measurements. The first value of
each sample is NA since weather values are averaged from row i to i-1.
}
\description{
Calculates average weather (humidity, temperature) values within a measurement period.
}
\details{
Averages within a measurement period are determined by
approximate integration and normalization of the weather as a function of time.
}
\examples{
# get example data
weight_loss_data <- leaf_drying_data
weather_data <- weather_data

# allocate averaged weather data to weight loss data
weight_loss_data_with_weather <- WeatherAllocation(weight_loss_data, weather_data)

}
