% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop1.R
\name{prop1}
\alias{prop1}
\title{Compute power for a single sample proportion test
Takes phi, degrees of freedom, and a range of sample sizes. Alpha is .05 by default, alternative values may be entered by user}
\usage{
prop1(p1, p0, nlow, nhigh, alpha = 0.05, tails = 2, by = 1)
}
\arguments{
\item{p1}{expected proportion (a.k.a. alternative proportion)}

\item{p0}{null proportion}

\item{nlow}{starting sample size}

\item{nhigh}{ending sample size}

\item{alpha}{Type I error (default is .05)}

\item{tails}{number of tails for test (default is 2)}

\item{by}{Incremental increase in sample (e.g. nlow = 10, nhigh = 24, by = 2, produces estimates of 10, 12, and 14)}
}
\value{
Power for Tests of Single Proportion
}
\description{
Compute power for a single sample proportion test
Takes phi, degrees of freedom, and a range of sample sizes. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
prop1(p1=.60, p0=.42,nlow=20,nhigh=100, tails=1, by=10)
}
